//=============================================================================
// PartyExpBoost.js
// ----------------------------------------------------------------------------
// (C)2024 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2024/07/09 初版
// ----------------------------------------------------------------------------
// [Site]   : https://ci-en.net/creator/14684
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 経験値全体補正プラグイン
 * @target MZ
 * @author くろあめ
 *
 * @help
 * 指定のメタタグをメモ欄に記載することで
 * パーティが入手する経験値に倍率をかけることができます
 * ツクール標準の経験値倍率補正は、アクター個人に対するものですが
 * 本プラグインは敵トループの総経験値そのものに補正をかけ
 * パーティ内全員に影響を与えます。
 * 
 * アクター、職業、装備、ステートのメモ欄に
 * <PartyExpBoost:xx>と記載することで 
 * パーティの入手経験値をxx%増加させることができます。
 * 
 * 複数の装備やステートに、上記タグが記述されていた場合
 * 最終的な倍率は加算で算出されます。
 * 
 * 例：<PartyExpBoost:10> と記述されたアクターがパーティに1人
 *     <PartyExpBoost:15> と記述された武器を装備するアクターがパーティに2人いる場合
 *     入手経験値は、元の経験値の140%となります。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {

const _Game_Troop_expTotal_kop = Game_Troop.prototype.expTotal;
Game_Troop.prototype.expTotal = function() {
     
    var base = _Game_Troop_expTotal_kop.call(this);
    var rate = 100;
    
    for (const member of $gameParty.members()) {
    
        var states = member.states();
        for (let i = 0; i < states.length; i++) {
            if (states[i] && states[i].meta && states[i].meta.PartyExpBoost) rate += Number(states[i].meta.PartyExpBoost);
        }
         
        if (member.actor() && member.actor().meta && member.actor().meta.PartyExpBoost) rate += Number(this.actor().meta.PartyExpBoost);
        if (member.currentClass() && member.currentClass().meta && member.currentClass().meta.PartyExpBoost) rate += Number(member.currentClass().meta.PartyExpBoost);
        var equips = member.equips();
        for (let i = 0; i < equips.length; i++) {
            if (equips[i] && equips[i].meta && equips[i].meta.PartyExpBoost) rate += Number(equips[i].meta.PartyExpBoost);
        }
    }
    //console.log(rate);
    return Math.round(base * rate / 100);

 };


})();
